<?php
/**
 * Uninstall cleanup for DevSniper.
 *
 * @package DevSniper
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Cleanup all DevSniper user meta on uninstall.
 *
 * Note: Wrapped in a function to avoid creating non-prefixed globals.
 *
 * @return void
 */
function devsniper_uninstall_cleanup() {

	$devsniper_meta_keys = array(
		'devsniper_inspector_enabled',
		'devsniper_favorites_search',
		'devsniper_favorites_elements',
	);

	$devsniper_user_ids = get_users(
		array(
			'fields' => 'ID',
		)
	);

	foreach ( $devsniper_user_ids as $devsniper_user_id ) {
		foreach ( $devsniper_meta_keys as $devsniper_key ) {
			delete_user_meta( $devsniper_user_id, $devsniper_key );
		}
	}
}

devsniper_uninstall_cleanup();
