<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Security helpers (capabilities + nonces).
 */
class DevSniper_Security {

	const AJAX_NONCE_ACTION = 'devsniper_nonce';

	/**
	 * Capability required for Inspector.
	 *
	 * @return string
	 */
	public static function required_capability() {
		$cap = apply_filters( 'devsniper_required_cap', 'manage_options' );

		return $cap ? $cap : 'manage_options';
	}

	/**
	 * Can current user use Inspector features.
	 *
	 * @return bool
	 */
	public static function current_user_can_use() {
		return current_user_can( self::required_capability() );
	}

	/**
	 * Capability check for admin search (editors/admins).
	 *
	 * @return bool
	 */
	public static function current_user_can_search() {
		return current_user_can( 'edit_posts' );
	}

	/**
	 * Verify nonce + capability for AJAX.
	 *
	 * @param string $nonce_field Nonce field key.
	 */
	public static function verify_ajax( $nonce_field = 'nonce' ) {
		check_ajax_referer( self::AJAX_NONCE_ACTION, $nonce_field );

		if ( ! self::current_user_can_use() ) {
			wp_send_json_error(
				array( 'message' => __( 'Unauthorized', 'devsniper' ) ),
				403
			);
		}
	}
}
