<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main plugin bootstrap.
 */
class DevSniper_Plugin {

	/**
	 * Initialize plugin.
	 */
	public static function init() {
		add_action( 'plugins_loaded', array( __CLASS__, 'boot_components' ) );
		add_action( 'admin_bar_menu', array( __CLASS__, 'add_admin_bar_button' ), 100 );
		add_action( 'wp_head', array( __CLASS__, 'render_fouc_guard' ), 0 );
	}

	/**
	 * Load text domain.
	 */

	/**
	 * Boot component classes.
	 */
	public static function boot_components() {
		DevSniper_Admin_Search::init();
		DevSniper_Inspector::init();
	}

	/**
	 * Admin bar button shared between admin search (backend) and inspector (frontend).
	 *
	 * @param WP_Admin_Bar $wp_admin_bar Admin bar object.
	 */
	public static function add_admin_bar_button( $wp_admin_bar ) {
		if ( is_admin() ) {
			if ( ! DevSniper_Security::current_user_can_search() ) {
				return;
			}
			$title = '🎯 DevSniper';
		} else {
			if ( ! DevSniper_Security::current_user_can_use() || ! is_user_logged_in() ) {
				return;
			}
			$title = '🎯';
		}

		$wp_admin_bar->add_node(
			array(
				'id'    => 'devsniper-search',
				'title' => $title,
				'href'  => '#',
				'meta'  => array(
					'title' => __( 'Open DevSniper', 'devsniper' ),
					'class' => 'devsniper-adminbar-link',
				),
			)
		);
	}

	/**
	 * Prevent flash of unstyled content for front-end visitors.
	 */
	public static function render_fouc_guard() {
		if ( is_admin() ) {
			return;
		}

		$enabled = apply_filters( 'devsniper_fouc_guard_enabled', true );
		if ( true !== $enabled ) {
			return;
		}
		?>
		<style id="devsniper-fouc-guard">
			html.devsniper-fouc body{opacity:0;transition:opacity .18s ease;}
		</style>
		<script>
			(function(){
				var docEl = document.documentElement;
				if (!docEl) return;
				docEl.classList.add('devsniper-fouc');
				var revealed = false;
				var reveal = function(){
					if (revealed) return;
					revealed = true;
					docEl.classList.remove('devsniper-fouc');
				};
				window.addEventListener('load', reveal, { once: true });
				setTimeout(reveal, 2500);
			})();
		</script>
		<?php
	}
}
