<?php
/**
 * Plugin Name: DevSniper – Global Developer Search
 * Description: Global developer search and front-end inspector for WordPress admins.
 * Version: 0.5.1
 * Author: InterestOffice
 * Author URI: https://interest.org.il
 * Plugin URI: https://interest.org.il/devsniper
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: devsniper
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'DEVSNIPER_VERSION', '0.5.1' );
define( 'DEVSNIPER_PATH', plugin_dir_path( __FILE__ ) );
define( 'DEVSNIPER_URL', plugin_dir_url( __FILE__ ) );
define( 'DEVSNIPER_FILE', __FILE__ );

require_once DEVSNIPER_PATH . 'includes/helpers.php';
require_once DEVSNIPER_PATH . 'includes/class-devsniper-security.php';
require_once DEVSNIPER_PATH . 'includes/class-devsniper-favorites.php';
require_once DEVSNIPER_PATH . 'includes/class-devsniper-admin-search.php';
require_once DEVSNIPER_PATH . 'includes/class-devsniper-inspector.php';
require_once DEVSNIPER_PATH . 'includes/class-devsniper-plugin.php';

DevSniper_Plugin::init();
