(function () {
  'use strict';

  if (!window.CSS || !CSS.escape) {
    window.CSS = window.CSS || {};
    CSS.escape =
      CSS.escape ||
      function (sel) {
        return (sel || '').replace(/[^a-zA-Z0-9_-]/g, '\\$&');
      };
  }

  const params = new URLSearchParams(window.location.search || '');
  const targetId = params.get('devsniper_select');
  if (!targetId) {
    return;
  }

  const MAX_ATTEMPTS = 40;
  let attempts = 0;

  function dispatchMouse(target, view) {
    const opts = { bubbles: true, cancelable: true, view: view };
    target.dispatchEvent(new MouseEvent('mousedown', opts));
    target.dispatchEvent(new MouseEvent('mouseup', opts));
    target.dispatchEvent(new MouseEvent('click', opts));
  }

  function trySelect() {
    const iframe = document.getElementById('elementor-preview-iframe');
    if (!iframe || !iframe.contentWindow || !iframe.contentDocument) {
      return false;
    }

    const doc = iframe.contentDocument;
    const selector = '.elementor-element[data-id="' + CSS.escape(targetId) + '"]';
    const target = doc.querySelector(selector);
    if (!target) {
      return false;
    }

    try {
      target.scrollIntoView({ behavior: 'smooth', block: 'center' });
    } catch (e) {
      // ignore
    }

    dispatchMouse(target, iframe.contentWindow);
    return true;
  }

  function tick() {
    attempts += 1;
    if (trySelect() || attempts >= MAX_ATTEMPTS) {
      clearInterval(timer);
    }
  }

  const timer = setInterval(tick, 350);

  const observer = new MutationObserver(function () {
    if (trySelect()) {
      clearInterval(timer);
      observer.disconnect();
    }
  });
  observer.observe(document.documentElement, { childList: true, subtree: true });

  window.addEventListener('load', function () {
    tick();
  });
})();

