(function($){
  const DEBOUNCE_DELAY = 200;
  let isOpen = false;
  let activeIndex = -1;
  let flatResults = [];
  let debounceTimer = null;
  let favourites = Array.isArray(DevSniperSearchData.favorites) ? DevSniperSearchData.favorites : [];

  const isAdminScreen = true;

  function escapeHtml(str){
    if (str === null || typeof str === 'undefined') return '';
    return String(str).replace(/[&<>"']/g, function(m){
      return ({
        '&':'&amp;',
        '<':'&lt;',
        '>':'&gt;',
        '"':'&quot;',
        "'":'&#39;'
      })[m];
    });
  }

  function openModal(){
    if (isOpen || DevSniperSearchData.settings.enabled === false) return;
    isOpen = true;
    activeIndex = -1;
    flatResults = [];
    $('#devsniper-overlay').show();
    $('#devsniper-modal').show();
    $('#devsniper-input').val('').focus();
    renderDefaultView();
  }

  function closeModal(){
    if (!isOpen) return;
    isOpen = false;
    $('#devsniper-overlay').hide();
    $('#devsniper-modal').hide();
  }

  function isFav(id){
    return favourites.some(function(f){ return f && f.id === id; });
  }

  function renderFavouriteItemsView(){
    const $results = $('#devsniper-results');
    if (!favourites.length){
      $results.html('<div class="devsniper-results-empty">'+ escapeHtml(DevSniperSearchData.i18n.no_favourites) +'</div>');
      flatResults = [];
      activeIndex = -1;
      return;
    }

    flatResults = [];
    activeIndex = -1;
    let html = '<div class="devsniper-section"><div class="devsniper-section-title">'+ escapeHtml(DevSniperSearchData.i18n.favourites) +'</div><ul class="devsniper-list">';

    favourites.forEach(function(item){
      if (!item) return;
      flatResults.push(item);
      const index = flatResults.length - 1;
      const title = escapeHtml(item.title || '');
      const meta  = escapeHtml(item.type || '');
      let letter = '';
      if (!item.thumb && !item.icon_class) {
        const base = (item.title || item.type || '').trim();
        letter = base ? base.charAt(0).toUpperCase() : '';
      }
      const favUrl = item.edit_url || item.url || '';
      html += '<li class="devsniper-item" data-index="'+index+'" data-url="'+ escapeHtml(favUrl) +'" data-id="'+ escapeHtml(item.id || '') +'">';
      html += '<button type="button" class="devsniper-item-fav is-active" aria-label="'+ escapeHtml(DevSniperSearchData.i18n.search_fav_tip)+'">★</button>';
      html += '<div class="devsniper-item-inner">';
      html += '<div class="devsniper-item-thumb">';
      if (item.thumb){
        html += '<img src="'+ escapeHtml(item.thumb) +'" alt="" loading="lazy" />';
      } else if (item.icon_class){
        html += '<div class="devsniper-item-thumb-fallback devsniper-item-thumb-icon"><span class="'+ escapeHtml(item.icon_class)+'"></span></div>';
      } else if (letter){
        html += '<div class="devsniper-item-thumb-fallback">'+ letter +'</div>';
      } else {
        html += '<div class="devsniper-item-thumb-fallback">?</div>';
      }
      html += '</div><div class="devsniper-item-text"><div class="devsniper-item-title">'+ title +'</div><div class="devsniper-item-meta">'+ meta +'</div></div></div></li>';
    });

    html += '</ul></div>';
    $results.html(html);
  }

  function renderDefaultView(){
    if (favourites.length){
      $('#devsniper-favorites-toggle').addClass('is-active');
      renderFavouriteItemsView();
    } else {
      $('#devsniper-favorites-toggle').removeClass('is-active');
      $('#devsniper-results').html('<div class="devsniper-results-empty">'+ escapeHtml(DevSniperSearchData.i18n.start_typing) +'</div>');
    }
  }

  function highlight(text, term){
    if (!term) return escapeHtml(text || '');
    const pattern = new RegExp((term || '').replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'ig');
    return escapeHtml(text || '').replace(pattern, function(match){
      return '<mark class="devsniper-mark">'+ escapeHtml(match) +'</mark>';
    });
  }

  function renderResults(data){
    const $container = $('#devsniper-results');
    flatResults = [];
    activeIndex = -1;
    $container.empty();
    const term = ($('#devsniper-input').val() || '').trim();
    let html = '';

    function section(label, items, enabled){
      if (!enabled || !items || !items.length) return;
      html += '<div class="devsniper-section"><div class="devsniper-section-title">'+ escapeHtml(label) +'</div><ul class="devsniper-list">';
      items.forEach(function(item){
        flatResults.push(item);
        const index = flatResults.length - 1;
        const favActive = isFav(item.id);
        let letter = '';
        if (!item.thumb && !item.icon_class){
          const base = (item.title || item.type || '').trim();
          letter = base ? base.charAt(0).toUpperCase() : '';
        }
        const itemUrl = item.edit_url || item.url || '';
        html += '<li class="devsniper-item" data-index="'+index+'" data-url="'+ escapeHtml(itemUrl) +'" data-id="'+ escapeHtml(item.id || '') +'">';
        html += '<button type="button" class="devsniper-item-fav'+(favActive?' is-active':'')+'" aria-label="'+ escapeHtml(DevSniperSearchData.i18n.search_fav_tip)+'">★</button>';
        html += '<div class="devsniper-item-inner">';
        html += '<div class="devsniper-item-thumb">';
        if (item.thumb){
          html += '<img src="'+ escapeHtml(item.thumb) +'" alt="" loading="lazy" />';
        } else if (item.icon_class){
          html += '<div class="devsniper-item-thumb-fallback devsniper-item-thumb-icon"><span class="'+ escapeHtml(item.icon_class)+'"></span></div>';
        } else if (letter){
          html += '<div class="devsniper-item-thumb-fallback">'+ letter +'</div>';
        } else {
          html += '<div class="devsniper-item-thumb-fallback">?</div>';
        }
        html += '</div><div class="devsniper-item-text"><div class="devsniper-item-title">'+ highlight(item.title || '', term) +'</div><div class="devsniper-item-meta">'+ escapeHtml(item.type || '') +'</div></div></div></li>';
      });
      html += '</ul></div>';
    }

    section(DevSniperSearchData.i18n.admin_label, data.admin_pages, DevSniperSearchData.settings.enable_admin_pages);
    section(DevSniperSearchData.i18n.posts_label, data.posts, DevSniperSearchData.settings.enable_posts);
    section(DevSniperSearchData.i18n.users_label, data.users, DevSniperSearchData.settings.enable_users);
    section(DevSniperSearchData.i18n.media_label, data.media, DevSniperSearchData.settings.enable_media);

    if (!flatResults.length){
      html = '<div class="devsniper-results-empty">'+ escapeHtml(DevSniperSearchData.i18n.no_results) +'</div>';
    }
    $container.html(html);
  }

  function doSearch(term){
    const t = (term || '').trim();
    if (!t){
      renderDefaultView();
      return;
    }

    $('#devsniper-favorites-toggle').removeClass('is-active');
    $('#devsniper-results').html('<div class="devsniper-results-empty">'+ escapeHtml(DevSniperSearchData.i18n.loading) +'</div>');

    $.ajax({
      url: DevSniperSearchData.ajax_url,
      method: 'GET',
      dataType: 'json',
      data: {
        action: 'devsniper_search',
        nonce: DevSniperSearchData.nonce,
        q: t
      }
    }).done(function(response){
      if (response && response.success){
        renderResults(response.data);
      } else {
        $('#devsniper-results').html('<div class="devsniper-results-empty">'+ escapeHtml(DevSniperSearchData.i18n.error) +'</div>');
      }
    }).fail(function(){
      $('#devsniper-results').html('<div class="devsniper-results-empty">'+ escapeHtml(DevSniperSearchData.i18n.error) +'</div>');
    });
  }

  function moveSelection(delta){
    const $items = $('.devsniper-item');
    if (!$items.length) return;
    activeIndex += delta;
    if (activeIndex < 0) activeIndex = $items.length - 1;
    if (activeIndex >= $items.length) activeIndex = 0;

    $items.removeClass('devsniper-item-active');
    const $active = $items.eq(activeIndex);
    $active.addClass('devsniper-item-active');

    const container = $('#devsniper-results')[0];
    const el = $active[0];
    if (container && el){
      const cRect = container.getBoundingClientRect();
      const eRect = el.getBoundingClientRect();
      if (eRect.top < cRect.top){
        container.scrollTop -= (cRect.top - eRect.top) + 10;
      } else if (eRect.bottom > cRect.bottom){
        container.scrollTop += (eRect.bottom - cRect.bottom) + 10;
      }
    }
  }

  function toggleFavourite($item){
    const id  = $item.data('id');
    const url = $item.data('url');
    const index = parseInt($item.data('index'), 10);
    const data = flatResults[index] || {};
    if (!id) return;
    const isActive = !$item.find('.devsniper-item-fav').hasClass('is-active');

    $.ajax({
      url: DevSniperSearchData.ajax_url,
      method: 'POST',
      dataType: 'json',
      data: {
        action: 'devsniper_toggle_favorite',
        nonce: DevSniperSearchData.nonce,
        id: id,
        title: data.title || '',
        url: data.edit_url || data.url || url || '',
        thumb: data.thumb || '',
        icon_class: data.icon_class || '',
        type: data.type || '',
        is_active: isActive ? 1 : 0
      }
    }).done(function(response){
      if (response && response.success){
        favourites = response.data.favorites || [];
        if (isActive){
          $item.find('.devsniper-item-fav').addClass('is-active');
        } else {
          $item.find('.devsniper-item-fav').removeClass('is-active');
        }
      }
    });
  }

  // Admin bar button
  $(document).on('click', '#wp-admin-bar-devsniper-search > a', function(e){
    e.preventDefault();
    e.stopPropagation();
    openModal();
  });

  // Overlay click to close
  $(document).on('click', '#devsniper-overlay', function(e){
    if (!isOpen) return;
    closeModal();
  });

  // Clicking outside modal closes it
  $(document).on('click', '#devsniper-modal', function(e){
    if (!isOpen) return;
    if ($(e.target).closest('.devsniper-modal-inner').length === 0){
      closeModal();
    }
  });

  // Close button
  $(document).on('click', '.devsniper-close', function(){
    closeModal();
  });

  // Keyboard shortcuts
  $(document).on('keydown.devsniper', function(e){
    if (DevSniperSearchData.settings.enabled === false) return;
    const key = (e.key || '').toLowerCase();
    const isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;
    if ((isMac && e.metaKey && key === 'k') || (!isMac && e.ctrlKey && key === 'k')){
      if (!DevSniperSearchData.settings.keyboard_shortcut) return;
      e.preventDefault();
      if (!isOpen){
        openModal();
      } else if (DevSniperSearchData.settings.shortcut_toggle){
        closeModal();
      } else {
        $('#devsniper-input').focus();
      }
    }
    if (!isOpen) return;
    if (key === 'escape'){
      e.preventDefault();
      closeModal();
    }
    if (key === 'arrowdown'){
      e.preventDefault();
      moveSelection(1);
    }
    if (key === 'arrowup'){
      e.preventDefault();
      moveSelection(-1);
    }
    if (key === 'enter' && activeIndex >= 0 && flatResults[activeIndex]){
      const target = flatResults[activeIndex];
      const targetUrl = target.edit_url || target.url;
      if (targetUrl){
        window.location = targetUrl;
      }
    }
  });

  // Input typing
  $(document).on('input', '#devsniper-input', function(){
    const val = $(this).val() || '';
    const term = val.trim();
    clearTimeout(debounceTimer);
    if (!term.length){
      renderDefaultView();
      return;
    }
    $('#devsniper-favorites-toggle').removeClass('is-active');
    debounceTimer = setTimeout(function(){ doSearch(term); }, DEBOUNCE_DELAY);
  });

  // Favorites toggle button near search bar
  $(document).on('click', '#devsniper-favorites-toggle', function(e){
    e.preventDefault();
    if (!favourites.length) return;
    const $btn = $(this);
    const nowActive = !$btn.hasClass('is-active');
    $('#devsniper-input').val('');
    if (nowActive){
      $btn.addClass('is-active');
      renderFavouriteItemsView();
    } else {
      $btn.removeClass('is-active');
      $('#devsniper-results').html('<div class="devsniper-results-empty">'+ escapeHtml(DevSniperSearchData.i18n.start_typing) +'</div>');
    }
  });

  // Star per item
  $(document).on('click', '.devsniper-item-fav', function(e){
    e.preventDefault();
    e.stopPropagation();
    const $item = $(this).closest('.devsniper-item');
    toggleFavourite($item);
  });

  // Click on item navigates
  $(document).on('click', '.devsniper-item', function(){
    const url = $(this).data('url');
    if (url){
      window.location = url;
    }
  });

  // Settings tabs (admin)
  $(document).on('click', '.devsniper-tab-link', function(e){
    e.preventDefault();
    const $btn = $(this);
    const target = $btn.data('tab');
    if (!target) return;
    const $wrap = $btn.closest('.devsniper-settings-tabs');
    $wrap.find('.devsniper-tab-link').removeClass('is-active');
    $btn.addClass('is-active');
    $wrap.find('.devsniper-tab-panel').removeClass('is-active');
    $wrap.find('#' + target).addClass('is-active');
  });

})(jQuery);
